/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.dialogs;

import com.aptana.git.core.github.IGithubPullRequest;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MergePullRequestDialog
extends StatusDialog {
    private Text commitMsgText;
    private String commitMsg;
    private Button deleteBranchButton;
    private boolean deleteBranch;
    private final IGithubPullRequest pr;

    public MergePullRequestDialog(Shell parentShell, IGithubPullRequest pr) {
        super(parentShell);
        this.setTitle(MessageFormat.format("Merge Pull Request #{0}", pr.getNumber()));
        this.pr = pr;
        this.deleteBranch = true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label commitMsgLabel = new Label(composite, 0);
        commitMsgLabel.setText("Commit message (optional) :");
        this.commitMsgText = new Text(composite, 2626);
        this.commitMsgText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(300, 100).create());
        this.commitMsgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MergePullRequestDialog.this.commitMsg = MergePullRequestDialog.this.commitMsgText.getText();
            }
        });
        this.deleteBranchButton = new Button(composite, 32);
        this.deleteBranchButton.setText(MessageFormat.format("Delete {0}:{1} branch if PR succesfully merged and closed.", this.pr.getHeadRepo().getOwner(), this.pr.getHeadRef()));
        this.deleteBranchButton.setSelection(this.deleteBranch);
        this.deleteBranchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergePullRequestDialog.this.deleteBranch = MergePullRequestDialog.this.deleteBranchButton.getSelection();
            }
        });
        return composite;
    }

    public String getCommitMessage() {
        return this.commitMsg;
    }

    public boolean deleteBranch() {
        return this.deleteBranch;
    }
}

